<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CSettings extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
		$this->name = "settings";
		$this->tpl_module = array(
			"mod_name" => "General"  , 
			"module_code" => $this->name
		);
		
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		if ($_GET["mod"] == $this->name) {

			parent::DoEvents();

			$sub = $_GET["sub"];
			$action = $_GET["action"];

			//$this->__install();


			switch ($sub) {

				case "landing":
					$_GET["sub"] = $sub = "generic";
				case "platforms/google":
				case "platforms/facebook":
				case "platforms/bing":
				case "platforms/opengraph":
				case "platforms/twitter":
				case "mobile":
				case "generic":

						$data = new CFormSettings($this->forms_path  . $sub . ".xml" ,$_CONF["forms"]["admintemplate"] , $this->db,$this->tables);
						$this->PrepareDashboard($data->form);

						if ($data->Done()) {

							$_POST["show_settings"] = "0";

							switch ($sub) {
								case "generic":
									if (!$_POST["set_logo"]) {
										unset($_POST["set_logo"]);
										CForm::DeleteFields($data->form , array("set_logo"));
									}

									if (!$_POST["set_logo_inv"]) {
										unset($_POST["set_logo_inv"]);
										CForm::DeleteFields($data->form , array("set_logo_inv"));
									}


									if (!$_POST["set_logo_small"]) {
										unset($_POST["set_logo_small"]);
										CForm::DeleteFields($data->form , array("set_logo_small"));
									}

									if (!$_POST["set_favicon"]) {
										unset($_POST["set_favicon"]);
										CForm::DeleteFields($data->form , array("set_favicon"));
									}

									$fields = CForm::KeyFields($data->form);
									$fields[] = "set_logo_alt";
									$fields[] = "set_logo_inv_alt";
									$fields[] = "set_logo_small_alt";
									$fields[] = "set_favicon_file";

									$this->SavePageConf();
								break;

								case "mobile":
									if (!$_POST["set_ios_icon"]) {
										unset($_POST["set_ios_icon"]);
										unset($data->form["fields"]["box"][0]["fields"]["set_ios_icon"]);
									}

									if (!$_POST["set_ios_loader"]) {
										unset($_POST["set_ios_loader"]);
										unset($data->form["fields"]["box"][0]["fields"]["set_ios_loader"]);
									}


								$fields = CForm::KeyFields($data->form);

								break;

								default:

									if ($sub == "platforms/opengraph") {

										if (!$_POST["set_og_img"]) {
											unset($_POST["set_og_img"]);
											CForm::DeleteFields($data->form , array("set_og_img"));
										}

									}
									
									$fields = CForm::KeyFields($data->form);
								break;

							}
							

							
							$this->vars->SetVars(
								$this->vars->ExtractVals(
									$fields,
									$_POST
								)
							);
						}

						$fields = CForm::KeyFields($data->form);
						$fields[] = "set_logo_alt";
						
						return $data->Show(							
							$this->vars->GetVars(
								$fields
							)
						
						);
				break;

				case "vars":					
					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);
					$this->PrepareFields($data->forms["forms"]);
					return $data->DoEvents();
				break;

			}
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SavePageConf() {

		$path = "../upload/conf/";

		$types = array(
			"0"	=> "prod",
			"1"	=> "dev",
			"2"	=> "dev",
		);

		$js = array(
			"type"	=> $types[$_POST["set_page_js"]],
			"cache"	=> $_POST["set_page_js"] == "2" ? false : true,
			"ver"	=> $_POST["set_page_js_ver"],
		);

		$css = array(
			"type"	=> $types[$_POST["set_page_css"]],
			"cache"	=> $_POST["set_page_css"] == "2" ? false : true,
			"ver"	=> $_POST["set_page_css_ver"],
		);

		$html = array(
			"type"	=> $_POST["set_page_htm"] ? "prod" : "dev",
		);

		$assets = array(
			"js"	=> $js,
			"css"	=> $css,
			"html"	=> $html,
		);

//		CFile::Save($path . "js.json" , json_encode($js));
//		CFile::Save($path . "css.json" , json_encode($css));
//		CFile::Save($path . "html.json" , json_encode($html));
		CFile::Save($path . "assets.json" , json_encode($assets));

	}
	

}

?>